// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Symbols.pas' rev: 10.00

#ifndef SymbolsHPP
#define SymbolsHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Symbols
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TBaseSymbol;
class PASCALIMPLEMENTATION TBaseSymbol : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TBaseSymbol* Next;
	
protected:
	AnsiString FIdent;
	
public:
	__fastcall TBaseSymbol(const AnsiString AIdent);
	__property AnsiString Ident = {read=FIdent};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TBaseSymbol(void) { }
	#pragma option pop
	
};


typedef bool __fastcall (__closure *TCompareSymbol)(const AnsiString Ident);

typedef bool __fastcall (*TCompareSymbols)(const System::ShortString &Ident1, const System::ShortString &Ident2);

#pragma option push -b-
enum TSymbolTableKind { stInsensitive, stCaseSensitive };
#pragma option pop

typedef DynamicArray<TBaseSymbol* >  Symbols__3;

class DELPHICLASS TSymbolList;
class PASCALIMPLEMENTATION TSymbolList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TBaseSymbol* __fastcall GetSymbol(int Index);
	
private:
	DynamicArray<TBaseSymbol* >  FList;
	int FCount;
	
public:
	__fastcall TSymbolList(void);
	__fastcall virtual ~TSymbolList(void);
	void __fastcall Clear(void);
	void __fastcall Add(TBaseSymbol* Sym);
	__property int Count = {read=FCount, nodefault};
	__property TBaseSymbol* Symbols[int Index] = {read=GetSymbol};
};


class DELPHICLASS TSymbolTable;
class PASCALIMPLEMENTATION TSymbolTable : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FCount;
	TBaseSymbol* FSymbolList[32];
	TCompareSymbols FCompare;
	
public:
	__fastcall TSymbolTable(TSymbolTableKind SymbolTableKind);
	__fastcall virtual ~TSymbolTable(void);
	void __fastcall Clear(void);
	bool __fastcall Contains(TBaseSymbol* Symbol);
	void __fastcall Delete(TBaseSymbol* Symbol);
	bool __fastcall Empty(void);
	void __fastcall Insert(TBaseSymbol* Symbol);
	TBaseSymbol* __fastcall Find(const AnsiString Ident);
	TBaseSymbol* __fastcall FindIndex(int SymbolIndex, const AnsiString Ident);
	TBaseSymbol* __fastcall FindNext(TBaseSymbol* Symbol);
	TBaseSymbol* __fastcall FindSymbol(int SymbolIndex, TCompareSymbol Compare);
	__property int Count = {read=FCount, nodefault};
};


class DELPHICLASS TTableIterator;
class PASCALIMPLEMENTATION TTableIterator : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TBaseSymbol* operator[](int Index) { return Symbols[Index]; }
	
private:
	int FLocation;
	int FIndex;
	TBaseSymbol* FSymbol;
	int FCount;
	TSymbolTable* FTable;
	TBaseSymbol* __fastcall GetSymbol(int Index);
	
public:
	__fastcall TTableIterator(TSymbolTable* Table);
	__property int Count = {read=FCount, nodefault};
	__property TBaseSymbol* Symbols[int Index] = {read=GetSymbol/*, default*/};
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TTableIterator(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
extern PACKAGE int __fastcall SymbolIndex(const AnsiString Ident);
extern PACKAGE bool __fastcall SameSymbol(const AnsiString Ident1, const AnsiString Ident2);
extern PACKAGE bool __fastcall SameSymbolShort(const System::ShortString &Ident1, const System::ShortString &Ident2);
extern PACKAGE bool __fastcall IdenticalSymbol(const System::ShortString &Ident1, const System::ShortString &Ident2);
extern PACKAGE bool __fastcall IdenticalText(const AnsiString Text1, const AnsiString Text2);

}	/* namespace Symbols */
using namespace Symbols;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Symbols
